<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Step 12 / 14: Admin Entries list page.
 */
add_action( 'admin_menu', function () {
	add_submenu_page(
		'edit.php?post_type=warform',
		'Entries',
		'Entries',
		'manage_options',
		'warforms-entries',
		'warforms_reboot_render_entries_page'
	);

	// Step 15: Hidden "View Entry" page.
	add_submenu_page(
		null,
		'Entry',
		'Entry',
		'manage_options',
		'warforms-entry',
		'warforms_reboot_render_entry_page'
	);
} );

function warforms_reboot_render_entries_page() {
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( esc_html__( 'You do not have permission to access this page.', 'warforms-reboot' ) );
	}

	$form_id  = isset( $_GET['form_id'] ) ? absint( $_GET['form_id'] ) : 0;
	$page     = isset( $_GET['wf_paged'] ) ? max( 1, absint( $_GET['wf_paged'] ) ) : 1;
	$per_page = 20;

	$view = isset( $_GET['view'] ) ? sanitize_key( (string) $_GET['view'] ) : '';
	$show_all = ( $view === 'all' );

	$entry_id = isset( $_GET['entry_id'] ) ? absint( $_GET['entry_id'] ) : 0;

	$base_url = add_query_arg(
		[
			'post_type' => 'warform',
			'page'      => 'warforms-entries',
		],
		admin_url( 'edit.php' )
	);

	echo '<div class="wrap">';
	echo '<h1>WarForms Entries</h1>';

	$index_url = add_query_arg( [ 'post_type' => 'warform', 'page' => 'warforms-entries' ], admin_url( 'edit.php' ) );
	if ( $form_id > 0 || $show_all ) {
		echo '<p><a href="' . esc_url( $index_url ) . '">&larr; ' . esc_html__( 'Back to forms', 'warforms-reboot' ) . '</a></p>';
	}

	// Filter bar.
	$forms = get_posts( [
		'post_type'      => 'warform',
		'post_status'    => [ 'publish', 'draft', 'pending', 'private' ],
		'posts_per_page' => 200,
		'orderby'        => 'title',
		'order'          => 'ASC',
	] );


	// Default UX: show a per-form index (like Gravity Forms) unless "view=all" is requested.
	if ( $form_id === 0 && ! $show_all ) {
		$stats = function_exists( 'warforms_reboot_get_entry_stats_by_form' ) ? warforms_reboot_get_entry_stats_by_form() : [];

		echo '<p style="margin: 10px 0 16px 0;">' . esc_html__( 'Select a form to view its entries.', 'warforms-reboot' ) . '</p>';

		$all_url = add_query_arg(
			[
				'post_type' => 'warform',
				'page'      => 'warforms-entries',
				'view'      => 'all',
			],
			admin_url( 'edit.php' )
		);
		echo '<p><a class="button" href="' . esc_url( $all_url ) . '">' . esc_html__( 'View all entries', 'warforms-reboot' ) . '</a></p>';

		echo '<table class="widefat striped" style="max-width: 900px;">';
		echo '<thead><tr>';
		echo '<th>' . esc_html__( 'Form', 'warforms-reboot' ) . '</th>';
		echo '<th style="width:120px;">' . esc_html__( 'Entries', 'warforms-reboot' ) . '</th>';
		echo '<th style="width:200px;">' . esc_html__( 'Last entry', 'warforms-reboot' ) . '</th>';
		echo '<th style="width:160px;">' . esc_html__( 'Actions', 'warforms-reboot' ) . '</th>';
		echo '</tr></thead><tbody>';

		foreach ( $forms as $f ) {
			$fid   = (int) $f->ID;
			$title = (string) $f->post_title;

			$count = isset( $stats[ $fid ]['total'] ) ? (int) $stats[ $fid ]['total'] : 0;
			$last_gmt = isset( $stats[ $fid ]['last_created_at'] ) ? (string) $stats[ $fid ]['last_created_at'] : '';
			$last_local = $last_gmt !== '' ? get_date_from_gmt( $last_gmt, 'Y-m-d H:i:s' ) : '';
			$last_cell = $last_local !== '' ? esc_html( $last_local ) : '&mdash;';

			$entries_url = add_query_arg(
				[
					'post_type' => 'warform',
					'page'      => 'warforms-entries',
					'form_id'   => $fid,
				],
				admin_url( 'edit.php' )
			);

			$edit_url = admin_url( 'post.php?post=' . $fid . '&action=edit' );

			echo '<tr>';
			echo '<td><strong><a href="' . esc_url( $entries_url ) . '">' . esc_html( $title ) . '</a></strong><br/>';
			echo '<span class="description"><a href="' . esc_url( $edit_url ) . '">' . esc_html__( 'Edit form', 'warforms-reboot' ) . '</a></span></td>';
			echo '<td>' . ( $count > 0 ? '<a href="' . esc_url( $entries_url ) . '">' . esc_html( (string) $count ) . '</a>' : '0' ) . '</td>';
			echo '<td>' . $last_cell . '</td>';
			echo '<td><a class="button button-small" href="' . esc_url( $entries_url ) . '">' . esc_html__( 'View entries', 'warforms-reboot' ) . '</a></td>';
			echo '</tr>';
		}

		if ( empty( $forms ) ) {
			echo '<tr><td colspan="4">' . esc_html__( 'No forms found.', 'warforms-reboot' ) . '</td></tr>';
		}

		echo '</tbody></table>';
		echo '</div>';

		return;
	}


	echo '<form method="get" style="margin: 12px 0;">';
	if ( $show_all ) {
		echo '<input type="hidden" name="view" value="all" />';
	}
	echo '<input type="hidden" name="post_type" value="warform" />';
	echo '<input type="hidden" name="page" value="warforms-entries" />';
	echo '<label for="wf_form_id" style="margin-right:8px;">' . esc_html__( 'Filter by form:', 'warforms-reboot' ) . '</label>';
	echo '<select id="wf_form_id" name="form_id">';
	echo '<option value="0">' . esc_html__( 'All forms', 'warforms-reboot' ) . '</option>';
	foreach ( $forms as $f ) {
		$selected = selected( $form_id, (int) $f->ID, false );
		echo '<option value="' . esc_attr( $f->ID ) . '"' . $selected . '>' . esc_html( $f->post_title ) . '</option>';
	}
	echo '</select> ';
	submit_button( __( 'Filter', 'warforms-reboot' ), 'secondary', '', false );
	echo '</form>';

	// Query entries.
	$result = function_exists( 'warforms_reboot_get_entries' )
		? warforms_reboot_get_entries( $form_id, $page, $per_page )
		: [ 'rows' => [], 'total' => 0 ];

	$rows  = isset( $result['rows'] ) && is_array( $result['rows'] ) ? $result['rows'] : [];
	$total = isset( $result['total'] ) ? (int) $result['total'] : 0;

	// Preload form titles for display.
	$form_titles = [];
	foreach ( $rows as $r ) {
		$fid = isset( $r->form_id ) ? (int) $r->form_id : 0;
		if ( $fid > 0 && ! isset( $form_titles[ $fid ] ) ) {
			$form_titles[ $fid ] = get_the_title( $fid );
		}
	}

	echo '<table class="widefat fixed striped">';
	echo '<thead><tr>';
	echo '<th style="width:80px;">' . esc_html__( 'ID', 'warforms-reboot' ) . '</th>';
	echo '<th>' . esc_html__( 'Form', 'warforms-reboot' ) . '</th>';
	echo '<th style="width:180px;">' . esc_html__( 'Date', 'warforms-reboot' ) . '</th>';
	echo '<th style="width:160px;">' . esc_html__( 'User', 'warforms-reboot' ) . '</th>';
	echo '<th style="width:140px;">' . esc_html__( 'IP', 'warforms-reboot' ) . '</th>';
	echo '<th style="width:120px;">' . esc_html__( 'Actions', 'warforms-reboot' ) . '</th>';
	echo '</tr></thead>';

	echo '<tbody>';
	if ( empty( $rows ) ) {
		echo '<tr><td colspan="6">' . esc_html__( 'No entries found.', 'warforms-reboot' ) . '</td></tr>';
	} else {
		foreach ( $rows as $r ) {
			$id  = isset( $r->id ) ? (int) $r->id : 0;
			$fid = isset( $r->form_id ) ? (int) $r->form_id : 0;

			$title = $fid > 0 ? ( $form_titles[ $fid ] ?? '' ) : '';
			if ( $title === '' ) {
				$title = $fid > 0 ? sprintf( __( 'Form #%d', 'warforms-reboot' ), $fid ) : __( '(unknown)', 'warforms-reboot' );
			}

			$form_entries = $fid > 0 ? add_query_arg( [ 'post_type' => 'warform', 'page' => 'warforms-entries', 'form_id' => $fid ], admin_url( 'edit.php' ) ) : '';
			$form_edit = $fid > 0 ? admin_url( 'post.php?post=' . $fid . '&action=edit' ) : '';
			if ( $fid > 0 ) {
				$form_cell = '<a href="' . esc_url( $form_entries ) . '">' . esc_html( $title ) . '</a>';
				$form_cell .= ' <span class="description">(' . '<a href="' . esc_url( $form_edit ) . '">' . esc_html__( 'edit', 'warforms-reboot' ) . '</a>' . ')</span>';
			} else {
				$form_cell = esc_html( $title );
			}
			$created_gmt = isset( $r->created_at ) ? (string) $r->created_at : '';
			$created_local = $created_gmt !== '' ? get_date_from_gmt( $created_gmt, 'Y-m-d H:i:s' ) : '';
			$date_cell = $created_local !== '' ? esc_html( $created_local ) : '&mdash;';

			$uid = isset( $r->user_id ) ? (int) $r->user_id : 0;
			if ( $uid > 0 ) {
				$u = get_userdata( $uid );
				$uname = $u ? ( $u->display_name ?: $u->user_login ) : sprintf( __( 'User #%d', 'warforms-reboot' ), $uid );
				$user_link = admin_url( 'user-edit.php?user_id=' . $uid );
				$user_cell = '<a href="' . esc_url( $user_link ) . '">' . esc_html( $uname ) . '</a>';
			} else {
				$user_cell = esc_html__( 'Guest', 'warforms-reboot' );
			}

			$ip = isset( $r->ip ) ? (string) $r->ip : '';
			$ip_cell = $ip !== '' ? esc_html( $ip ) : '&mdash;';

			$view_url = add_query_arg(
				[
					'post_type' => 'warform',
					'page'      => 'warforms-entry',
					'entry_id'  => $id,
					'_wpnonce'  => wp_create_nonce( 'warforms_view_entry_' . $id ),
				],
				admin_url( 'edit.php' )
			);
echo '<tr>';
			echo '<td>' . esc_html( (string) $id ) . '</td>';
			echo '<td>' . $form_cell . '</td>';
			echo '<td>' . $date_cell . '</td>';
			echo '<td>' . $user_cell . '</td>';
			echo '<td>' . $ip_cell . '</td>';
			echo '<td><a href="' . esc_url( $view_url ) . '">' . esc_html__( 'View', 'warforms-reboot' ) . '</a></td>';
			echo '</tr>';
		}
	}
	echo '</tbody>';
	echo '</table>';

	// Pagination.
	$total_pages = $per_page > 0 ? (int) ceil( $total / $per_page ) : 1;
	if ( $total_pages < 1 ) {
		$total_pages = 1;
	}

	if ( $total_pages > 1 ) {
		echo '<div class="tablenav"><div class="tablenav-pages" style="margin: 12px 0;">';

		for ( $p = 1; $p <= $total_pages; $p++ ) {
			$url = add_query_arg(
				[
					'form_id'  => $form_id,
					'wf_paged' => $p,
				],
				$base_url
			);

			if ( $p === $page ) {
				echo '<span class="page-numbers current" style="margin-right:6px;">' . esc_html( (string) $p ) . '</span>';
			} else {
				echo '<a class="page-numbers" style="margin-right:6px;" href="' . esc_url( $url ) . '">' . esc_html( (string) $p ) . '</a>';
			}
		}

		echo '</div></div>';
	}

	echo '</div>';
}

/**
 * Step 15/16: Render the single Entry "View" screen.
 */
function warforms_reboot_render_entry_page() {
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( esc_html__( 'Sorry, you are not allowed to access this page.', 'warforms-reboot' ) );
	}

	$entry_id = isset( $_GET['entry_id'] ) ? (int) $_GET['entry_id'] : 0;
	if ( $entry_id <= 0 ) {
		echo '<div class="wrap"><h1>' . esc_html__( 'Entry', 'warforms-reboot' ) . '</h1>';
		echo '<p>' . esc_html__( 'Missing entry_id.', 'warforms-reboot' ) . '</p></div>';
		return;
	}

	$nonce = isset( $_GET['_wpnonce'] ) ? (string) $_GET['_wpnonce'] : '';
	if ( $nonce === '' || ! wp_verify_nonce( $nonce, 'warforms_view_entry_' . $entry_id ) ) {
		wp_die( esc_html__( 'Invalid request (nonce failed).', 'warforms-reboot' ) );
	}

	if ( ! function_exists( 'warforms_reboot_get_entry' ) ) {
		echo '<div class="wrap"><h1>' . esc_html__( 'Entry', 'warforms-reboot' ) . '</h1>';
		echo '<p>' . esc_html__( 'Entries DB helper missing.', 'warforms-reboot' ) . '</p></div>';
		return;
	}

	$row = warforms_reboot_get_entry( $entry_id );
	if ( ! $row ) {
		echo '<div class="wrap"><h1>' . esc_html__( 'Entry not found', 'warforms-reboot' ) . '</h1></div>';
		return;
	}

	$form_id = isset( $row->form_id ) ? (int) $row->form_id : 0;
	$form    = $form_id > 0 ? get_post( $form_id ) : null;
	$title   = ( $form && $form->post_title ) ? $form->post_title : sprintf( __( 'Form #%d', 'warforms-reboot' ), $form_id );

	$created_gmt   = isset( $row->created_at ) ? (string) $row->created_at : '';
	$created_local = $created_gmt !== '' ? get_date_from_gmt( $created_gmt, 'Y-m-d H:i:s' ) : '';

	$uid = isset( $row->user_id ) ? (int) $row->user_id : 0;
	$uobj = $uid > 0 ? get_userdata( $uid ) : null;
	$user_display = $uobj ? ( ( $uobj->display_name ?: $uobj->user_login ) ) : ( $uid > 0 ? sprintf( __( 'User #%d', 'warforms-reboot' ), $uid ) : __( 'Guest', 'warforms-reboot' ) );

	$ip = isset( $row->ip ) ? (string) $row->ip : '';

	$payload_raw = isset( $row->payload_json ) ? (string) $row->payload_json : '';
	$payload     = json_decode( $payload_raw, true );
	if ( ! is_array( $payload ) ) {
		$payload = [];
	}
	$values  = isset( $payload['values'] ) && is_array( $payload['values'] ) ? $payload['values'] : [];
	$context = isset( $payload['context'] ) && is_array( $payload['context'] ) ? $payload['context'] : [];

	$schema = function_exists( 'warforms_reboot_get_schema' ) ? warforms_reboot_get_schema( $form_id ) : [ 'fields' => [] ];
	$fields = isset( $schema['fields'] ) && is_array( $schema['fields'] ) ? $schema['fields'] : [];

	// Helper to format a value safely for display.
	$format_value = function ( $v ) {
		if ( is_array( $v ) ) {
			// Currency: {currency, amount}
			if ( isset( $v['currency'] ) || isset( $v['amount'] ) ) {
				$cur = isset( $v['currency'] ) ? (string) $v['currency'] : '';
				$amt = isset( $v['amount'] ) ? (string) $v['amount'] : '';
				$out = trim( $cur . ' ' . $amt );
				return $out !== '' ? $out : wp_json_encode( $v );
			}
			// Sequential list.
			if ( array_keys( $v ) === range( 0, count( $v ) - 1 ) ) {
				return implode( ', ', array_map( 'strval', $v ) );
			}
			return wp_json_encode( $v );
		}
		return (string) $v;
	};

	echo '<div class="wrap">';
	echo '<h1>' . esc_html( sprintf( __( 'Entry #%d', 'warforms-reboot' ), $entry_id ) ) . '</h1>';

	// Meta.
	echo '<p style="margin-top:8px;">';
	if ( $form_id > 0 ) {
		$form_edit = admin_url( 'post.php?post=' . $form_id . '&action=edit' );
		echo '<strong>' . esc_html__( 'Form:', 'warforms-reboot' ) . '</strong> <a href="' . esc_url( $form_edit ) . '">' . esc_html( $title ) . '</a>';
	} else {
		echo '<strong>' . esc_html__( 'Form:', 'warforms-reboot' ) . '</strong> ' . esc_html( $title );
	}
	if ( $created_local !== '' ) {
		echo ' &nbsp; | &nbsp; <strong>' . esc_html__( 'Date:', 'warforms-reboot' ) . '</strong> ' . esc_html( $created_local );
	}
	echo ' &nbsp; | &nbsp; <strong>' . esc_html__( 'User:', 'warforms-reboot' ) . '</strong> ' . esc_html( $user_display );
	if ( $ip !== '' ) {
		echo ' &nbsp; | &nbsp; <strong>' . esc_html__( 'IP:', 'warforms-reboot' ) . '</strong> ' . esc_html( $ip );
	}
	echo '</p>';

	// Values table.
	echo '<h2 style="margin-top:18px;">' . esc_html__( 'Submitted values', 'warforms-reboot' ) . '</h2>';
	echo '<table class="widefat striped"><tbody>';

	$seen_keys = [];

	foreach ( $fields as $field ) {
		if ( ! is_array( $field ) ) {
			continue;
		}
		$name  = isset( $field['name'] ) ? (string) $field['name'] : '';
		$label = isset( $field['label'] ) ? (string) $field['label'] : '';
		if ( $name === '' ) {
			continue;
		}
		$key = function_exists( 'warforms_reboot_normalize_field_name' ) ? warforms_reboot_normalize_field_name( $name ) : sanitize_key( $name );
		$seen_keys[ $key ] = true;

		$val = array_key_exists( $key, $values ) ? $values[ $key ] : '';
		$type = isset( $field['type'] ) ? (string) $field['type'] : '';
		if ( $type === 'phone' && function_exists( 'warforms_reboot_format_phone_display' ) ) {
			$val_s = warforms_reboot_format_phone_display( $val );
		} else {
			$val_s = $format_value( $val );
		}
		$val_s = $val_s === '' ? '—' : $val_s;

		$label_out = $label !== '' ? $label : $key;

		echo '<tr>';
		echo '<th style="width:220px;">' . esc_html( $label_out ) . '</th>';
		echo '<td>' . esc_html( $val_s ) . '</td>';
		echo '</tr>';
	}

	// Any extra keys not in schema.
	foreach ( $values as $k => $v ) {
		$kk = (string) $k;
		if ( isset( $seen_keys[ $kk ] ) ) {
			continue;
		}
		$val_s = $format_value( $v );
		$val_s = $val_s === '' ? '—' : $val_s;
		echo '<tr>';
		echo '<th style="width:220px;">' . esc_html( $kk ) . '</th>';
		echo '<td>' . esc_html( $val_s ) . '</td>';
		echo '</tr>';
	}

	echo '</tbody></table>';

	// Context (helpful for debugging).
	if ( ! empty( $context ) ) {
		echo '<h2 style="margin-top:18px;">' . esc_html__( 'Context', 'warforms-reboot' ) . '</h2>';
		echo '<table class="widefat striped"><tbody>';
		foreach ( $context as $k => $v ) {
			$val_s = $format_value( $v );
			echo '<tr><th style="width:220px;">' . esc_html( (string) $k ) . '</th><td>' . esc_html( $val_s ) . '</td></tr>';
		}
		echo '</tbody></table>';
	}

	// Raw JSON.
	echo '<details style="margin-top:18px;"><summary>' . esc_html__( 'Raw JSON', 'warforms-reboot' ) . '</summary>';
	echo '<pre style="white-space:pre-wrap; max-width: 100%; overflow:auto; padding:12px; background:#fff; border:1px solid #ccd0d4;">' . esc_html( $payload_raw ) . '</pre>';
	echo '</details>';

	echo '</div>';
}
